#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_content.component.association.interfaces.paragraph import IAssociationParagraph
from pyams_skin.layer import IPyAMSLayer
from z3c.table.interfaces import IColumn

# import packages
from pyams_content.component.association.zmi import AssociationsTable
from pyams_skin.table import I18nColumn, I18nValueColumn
from pyams_utils.adapter import adapter_config
from pyams_utils.text import get_text_start

from onf_website import _


@adapter_config(name='description', context=(IAssociationParagraph, IPyAMSLayer, AssociationsTable),
                provides=IColumn)
class AssociationsTableDescriptionColumn(I18nColumn, I18nValueColumn):
    """Associations table description column"""

    _header = _("Associated text")
    attrName = "description"
    weight = 15

    def getValue(self, obj):
        if hasattr(obj, self.attrName):
            value = super(AssociationsTableDescriptionColumn, self).getValue(obj)
            return get_text_start(value, 100, 5)
        else:
            return '--'
