#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from pyams_content.component.association.interfaces.paragraph import IAssociationParagraph
from pyams_content.component.links.interfaces import IInternalLink
from pyams_content.component.paragraph import IParagraphContainer
from pyams_content.component.paragraph.interfaces.html import HTML_PARAGRAPH_TYPE
from pyams_content.features.renderer.interfaces import IContentRenderer
from pyams_content.shared.common import IWfSharedContent
from pyams_default_theme.component.association import AssociationParagraphDefaultRenderer, \
    AssociationParagraphRemoteContentRenderer, AssociationParagraphSlicedRemoteContentRenderer
from pyams_i18n.interfaces import II18n
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import override_template
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_utils.html import html_to_text

__docformat__ = 'restructuredtext'

from onf_website import _


override_template(name='PARA:title-left',
                  context=AssociationParagraphRemoteContentRenderer, layer=IPyAMSLayer,
                  template='templates/association-remote-content-title-left.pt')
override_template(name='PARA:title-left',
                  context=AssociationParagraphSlicedRemoteContentRenderer, layer=IPyAMSLayer,
                  template='templates/association-remote-content-title-left.pt')


#
# Associations paragraph default renderer
#

@adapter_config(name='default',
                context=(IAssociationParagraph, IPyAMSLayer),
                provides=IContentRenderer)
@template_config(template='templates/association-default.pt',
                 layer=IPyAMSLayer)
@template_config(name='PARA:title-left',
                 template='templates/association-title-left.pt',
                 layer=IPyAMSLayer)
class ONFAssociationParagraphDefaultRenderer(AssociationParagraphDefaultRenderer):
    """Associations paragraph default renderer"""

    label = _("ONF: Default associations renderer")
    weight = 1

    settings_interface = None


@adapter_config(name='files-action',
                context=(IAssociationParagraph, IPyAMSLayer),
                provides=IContentRenderer)
@template_config(template='templates/association-files-action.pt',
                 layer=IPyAMSLayer)
@template_config(name='PARA:title-left',
                 template='templates/association-files-action-title-left.pt',
                 layer=IPyAMSLayer)
class ONFAssociationParagraphFilesActionRenderer(AssociationParagraphDefaultRenderer):
    """Associations paragraph files 'call-to-action' renderer"""

    label = _("ONF: Files call-to-action associations renderer")
    weight = 5

    settings_interface = None


@adapter_config(name='links-action',
                context=(IAssociationParagraph, IPyAMSLayer),
                provides=IContentRenderer)
@template_config(template='templates/association-links-action.pt',
                 layer=IPyAMSLayer)
class ONFAssociationParagraphLinksActionRenderer(AssociationParagraphDefaultRenderer):
    """Associations paragraph links 'call-to-action' renderer"""

    label = _("ONF: Links call-to-action associations renderer")
    weight = 6

    settings_interface = None

    @property
    def head_title(self):
        title = II18n(self.context).query_attribute('title', request=self.request)
        if not title:
            title = self.request.localizer.translate(_("Read also"))
        return title


class ONFBaseInternalAssociationParagraphRenderer(ONFAssociationParagraphDefaultRenderer):
    """Base Internal associations paragraph renderer"""

    @staticmethod
    def is_internal_link(link):
        return IInternalLink.providedBy(link)


@adapter_config(name='resources',
                context=(IAssociationParagraph, IPyAMSLayer),
                provides=IContentRenderer)
@template_config(template='templates/association-resources.pt',
                 layer=IPyAMSLayer)
class ONFInternalResourcesAssociationParagraphRenderer(ONFBaseInternalAssociationParagraphRenderer):
    """Internal resources associations paragraph renderer"""

    label = _("ONF: Internal resources sheets")
    weight = 10

    def get_associated_text(self, link):
        description = II18n(link).query_attribute('description', request=self.request)
        if description:
            return description
        if IWfSharedContent.providedBy(link.target):
            header = II18n(link.target).query_attribute('header', request=self.request)
            if header:
                return header
        container = IParagraphContainer(link.target, None)
        if container is not None:
            for paragraph in container.get_visible_paragraphs(factories=(HTML_PARAGRAPH_TYPE,)):
                return html_to_text(II18n(paragraph).query_attribute('body', request=self.request))


@adapter_config(name='reference',
                context=(IAssociationParagraph, IPyAMSLayer),
                provides=IContentRenderer)
@template_config(template='templates/association-reference.pt',
                 layer=IPyAMSLayer)
class ONFInternalReferenceAssociationParagraphRenderer(ONFBaseInternalAssociationParagraphRenderer):
    """Internal references associations paragraph renderer"""

    label = _("ONF: Internal reference card renderer")
    weight = 15


@adapter_config(name='navtopic',
                context=(IAssociationParagraph, IPyAMSLayer),
                provides=IContentRenderer)
@template_config(template='templates/association-topic.pt',
                 layer=IPyAMSLayer)
class ONFInternalTopicAssociationParagraphRenderer(ONFBaseInternalAssociationParagraphRenderer):
    """Internal topics associations paragraph renderer"""

    label = _("ONF: Overlapped navigation banners")
    weight = 20

    button_label = _("See |folder")
    
    
@adapter_config(name='searchlist',
                context=(IAssociationParagraph, IPyAMSLayer),
                provides=IContentRenderer)
@template_config(template='templates/association-searchlist.pt',
                 layer=IPyAMSLayer)
class ONFSearchListAssociationParagraphRenderer(ONFBaseInternalAssociationParagraphRenderer):
    """Search list associations paragraph renderer"""

    label = _("ONF: List with search input")
    weight = 25


@adapter_config(name='framed-action',
                context=(IAssociationParagraph, IPyAMSLayer),
                provides=IContentRenderer)
@template_config(template='templates/association-frame-action.pt',
                 layer=IPyAMSLayer)
class ONFAssociationParagraphFrameActionRenderer(AssociationParagraphDefaultRenderer):
    """Call-to-action framed paragraph renderer"""

    label = _("ONF: framed, call-to-action")
    weight = 30
