#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""
This module contains onf_website package
"""
import os

from setuptools import find_packages, setup


DOCS = os.path.join(os.path.dirname(__file__),
                    'docs')

README = os.path.join(DOCS, 'README.txt')
HISTORY = os.path.join(DOCS, 'HISTORY.txt')

version = '2.19.11'
long_description = open(README).read() + '\n\n' + open(HISTORY).read()

tests_require = []

setup(name='onf_website',
      version=version,
      description="PyAMS base content __interfaces and classes",
      long_description=long_description,
      classifiers=[
          "License :: OSI Approved :: Zope Public License",
          "Development Status :: 4 - Beta",
          "Programming Language :: Python",
          "Framework :: Pyramid",
          "Topic :: Software Development :: Libraries :: Python Modules",
      ],
      keywords='Pyramid PyAMS',
      author='Thierry Florac',
      author_email='tflorac@ulthar.net',
      url='http://subversion.onf.fr/hg/apps/onf_website',
      license='ZPL',
      packages=find_packages('src'),
      package_dir={'': 'src'},
      namespace_packages=[],
      include_package_data=True,
      package_data={'': ['*.zcml', '*.txt', '*.pt', '*.pot', '*.po', '*.mo', '*.png', '*.gif',
                         '*.jpeg', '*.jpg', '*.css', '*.js']},
      zip_safe=False,
      # uncomment this to be able to run tests with setup.py
      test_suite="onf_website.tests.test_utilsdocs.test_suite",
      tests_require=tests_require,
      extras_require=dict(test=tests_require),
      install_requires=[
          'setuptools',
          # -*- Extra requirements: -*-
          'firebase-admin',
          'GeoAlchemy2',
          'hypatia',
          'myams',
          'pyams_alchemy',
          'pyams_catalog',
          'pyams_content >= 0.1.57',
          'pyams_content_es',
          'pyams_default_theme >= 0.1.38',
          'pyams_file',
          'pyams_form >= 0.1.13',
          'pyams_gis',
          'pyams_i18n',
          'pyams_ldap',
          'pyams_mail',
          'pyams_pagelet',
          'pyams_portal',
          'pyams_scheduler',
          'pyams_security',
          'pyams_sequence',
          'pyams_skin >= 0.1.37',
          'pyams_template',
          'pyams_thesaurus',
          'pyams_utils >= 0.1.31',
          'pyams_viewlet >= 0.1.5',
          'pyams_workflow',
          'pyams_zmi',
          'pyramid',
          'SQLAlchemy',
          'z3c.form',
          'z3c.table',
          'zodbupdate',
          'zope.annotation',
          'zope.component',
          'zope.container',
          'zope.interface',
          'zope.lifecycleevent',
          'zope.location',
          'zope.schema',
          'zope.traversing',
      ],
      entry_points={
          'fanstatic.libraries': [
              'onf_website = onf_website.skin.public:library',
              'onf_website.zmi = onf_website.skin.zmi:library'
          ],
          'zodbupdate': {
              'renames = onf_website.generations:RENAMED_CLASSES'
          }
      })
