#
# Copyright (c) 2008-2017 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from pyramid.decorator import reify
from zope.interface import Interface

from onf_website.features.header.interfaces import IDefaultHeaderRendererSettings
from onf_website.skin.public.layer import IONFBaseLayer, IONFSatelliteLayer
from pyams_content.features.header.interfaces import IHeaderSettings, IHeaderTarget
from pyams_content.interfaces import IBaseContent
from pyams_content.root.interfaces import ISiteRoot
from pyams_content.shared.common import ISharedSite
from pyams_content.shared.site.interfaces import ISiteContainer
from pyams_i18n.interfaces import II18n
from pyams_skin.interfaces.configuration import IConfiguration
from pyams_template.template import override_template, template_config
from pyams_utils.traversing import get_parent
from pyams_utils.url import absolute_url
from pyams_viewlet.viewlet import ViewContentProvider, contentprovider_config


# import standard library


@contentprovider_config(name='pyams.logo',
                        layer=IONFBaseLayer, view=Interface)
@template_config(template='templates/logo.pt', layer=IONFBaseLayer)
class Logo(ViewContentProvider):
    """Logo content provider"""

    @reify
    def settings(self):
        target = get_parent(self.request.display_context, IHeaderTarget)
        settings = IHeaderSettings(target)
        while settings.inherit:
            settings = IHeaderSettings(settings.parent)
        return IDefaultHeaderRendererSettings(settings.settings, None)

    @property
    def head_title(self):
        context = self.request.context
        if ISiteRoot.providedBy(context) or ISharedSite.providedBy(context):
            if ISiteRoot.providedBy(context):
                return IConfiguration(context).title
            if IBaseContent.providedBy(context):
                return II18n(context).query_attribute('title', request=self.request)
            logo = getattr(self.settings, 'logo', None)
            if logo:
                return logo.title
        return None

    @property
    def target(self):
        return absolute_url(self.request.root, request=self.request)


@contentprovider_config(name='pyams.logo',
                        context=ISiteRoot, layer=IONFBaseLayer, view=Interface)
@contentprovider_config(name='pyams.logo',
                        context=ISiteContainer, layer=IONFBaseLayer, view=Interface)
@template_config(template='templates/siteroot-logo.pt', layer=IONFBaseLayer)
class SiteRootLogo(Logo):
    """Site root logo content provider"""


override_template(context=SiteRootLogo, layer=IONFSatelliteLayer,
                  template='templates/satellite-logo.pt')
