#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Interface

from onf_website.skin.public import onf_territories_skin
from onf_website.skin.public.layer import IONFSatelliteLayer
from pyams_skin.interfaces import ISkin
from pyams_skin.interfaces.resources import IResources
from pyams_utils.adapter import ContextRequestViewAdapter, adapter_config
from pyams_utils.registry import utility_config

from onf_website import _


class IONFTerritoriesLayer(IONFSatelliteLayer):
    """ONF territories skin layer"""


@utility_config(name='ONF territories skin', provides=ISkin)
class ONFTerritoriesSkin(object):
    """ONF territories skin"""

    label = _("ONF: territories skin")
    layer = IONFTerritoriesLayer


@adapter_config(context=(Interface, IONFTerritoriesLayer, Interface), provides=IResources)
class ONFTerritoriesLayerResourcesAdapter(ContextRequestViewAdapter):
    """Territories layer resources adapter"""

    resources = (onf_territories_skin,)
