#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from zope.interface import Interface

__docformat__ = 'restructuredtext'

from pyams_file.schema import ImageField

from onf_website import _


class ILiveHomeBackgroundImagePortletSettings(Interface):
    """Live home background image portlet settings interface"""

    foreground_image = ImageField(title=_("Foreground image"),
                                  required=False)

    overlay_image = ImageField(title=_("Overlay image"),
                               required=False)
