#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'

from onf_website.component.paragraph.skin.interfaces.html import IHTMLParagraphCustomRenderer
from onf_website.shared.longread import IWfLongRead
from onf_website.skin.public.satellite.live import IONFLiveLayer
from pyams_content.component.illustration import IIllustration
from pyams_content.component.paragraph import IParagraphContainerTarget
from pyams_content.component.paragraph.interfaces.html import IHTMLParagraph
from pyams_default_theme.component.paragraph.html import HTMLParagraphDefaultRenderer
from pyams_i18n.interfaces import II18n
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_utils.traversing import get_parent


@adapter_config(context=(IHTMLParagraph, IONFLiveLayer),
                provides=IHTMLParagraphCustomRenderer)
@template_config(template='templates/html-longread-live.pt', layer=IONFLiveLayer)
class LongReadLiveLayerHTMLParagraphCustomRenderer(HTMLParagraphDefaultRenderer):
    """Long-read live layer HTML paragraph custom renderer"""

    def __new__(cls, context, request):
        if not context.anchor:
            return None
        content = get_parent(context, IParagraphContainerTarget)
        if (content is None) or not IWfLongRead.providedBy(content):
            return None
        illustration = IIllustration(context)
        if II18n(illustration).query_attribute('data', request=request):
            return None
        return HTMLParagraphDefaultRenderer.__new__(cls)
