#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import Interface

from onf_website.shared.common.skin.card import SharedContentCard
from onf_website.shared.common.skin.interfaces import IContentCard
from onf_website.skin.public.satellite.live import IONFLiveLayer
from pyams_content.shared.common import IWfSharedContent
from pyams_content.shared.news import IWfNewsEvent
from pyams_utils.adapter import adapter_config

__docformat__ = 'restructuredtext'


@adapter_config(context=(IWfSharedContent, IONFLiveLayer, Interface),
                provides=IContentCard)
@adapter_config(context=(IWfNewsEvent, IONFLiveLayer, Interface),
                provides=IContentCard)
class LiveLayerSharedContentCard(SharedContentCard):
    """Shared content card adapter for forest live skin"""

    css_class = 'card card--white'
