#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'

from onf_website.skin.public.satellite.live import IONFLiveLayer
from pyams_content.shared.site import IWfSiteTopic
from pyams_content.shared.topic import IWfTopic
from pyams_default_theme.features.header.skin import INavigationClass
from pyams_utils.adapter import adapter_config


@adapter_config(context=(IWfTopic, IONFLiveLayer),
                provides=INavigationClass)
@adapter_config(context=(IWfSiteTopic, IONFLiveLayer),
                provides=INavigationClass)
def live_skin_topic_navigation_class_adapter(context, request):
    """Generic header class adapter"""
    return 'wrapper-nav--tree'
