#
# Copyright (c) 2008-2019 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from onf_website.features.header.skin import ONFDefaultHeaderRenderer
from onf_website.skin.public.layer import IONFSatelliteLayer
from pyams_content.shared.site.interfaces import ISiteManager
from pyams_default_theme.features.header.skin import IHeaderClass
from pyams_template.template import override_template
from pyams_utils.adapter import adapter_config


#
# Satellite sites adapters
#

override_template(context=ONFDefaultHeaderRenderer, layer=IONFSatelliteLayer,
                  template='templates/satellite-header.pt')


@adapter_config(context=(ISiteManager, IONFSatelliteLayer), provides=IHeaderClass)
def site_container_header_class_adapter(context, request):
    """Site container header class adapter"""
    return 'wrapper-header--homeSatellite'
