(function($, globals) {

	'use strict';

	var ams = globals.MyAMS;

	globals.ONF = {

		/**
		 * Search engines management
		 */
		search: {

			clearSelection: function(evt) {
				var select = $(evt.currentTarget).data('select2');
				if (select) {
					select.val(null);
				}
			},

			updateSearch: function(evt) {
				var form = $(evt.currentTarget).parents('form');
				if (!form.exists()) {
					form = $('form[id="recherche-results"]');
				}
				if (form.exists()) {
					$('input[name="start"]', form).val(0);
					$('input[name="map_center"]', form).val('');
					$('.opsmap__area_filter').addClass('hidden');
					if (form.data('onf-submit-on-change') === true) {
						var value = $(evt.currentTarget).val();
						if (value || (form.data('onf-submit-on-clear') === true)) {
							form.submit();
						}
					}
				}
			},

			updateSort: function() {
				var form = $('form[id="recherche-results"]');
				if (form.exists()) {
					var index = $(this).data('ams-sort-index');
					$('input[name="order_by"]', form).val(index);
					form.submit();
				}
			},

			updatePageLength: function() {
				var form = $('form[id="recherche-results"]');
				if (form.exists()) {
					var length = $(this).val();
					$('input[name="start"]', form).val(0);
					$('input[name="length"]', form).val(length);
					form.submit();
				}
			},

			previousPage: function() {
				var form = $('form[id="recherche-results"]');
				if (form.exists()) {
					var current = $(this).parents('ol.pagination').data('ams-current-page');
					var length = $('input[name="length"]', form).val();
					$('input[name="start"]', form).val(length * (current - 2));
					form.submit();
				}
			},

			nextPage: function() {
				var form = $('form[id="recherche-results"]');
				if (form.exists()) {
					var current = $(this).parents('ol.pagination').data('ams-current-page');
					var length = $('input[name="length"]', form).val();
					$('input[name="start"]', form).val(length * current);
					form.submit();
				}
			},

			gotoPage: function() {
				var form = $('form[id="recherche-results"]');
				if (form.exists()) {
					var target = parseInt($(this).text());
					var length = $('input[name="length"]', form).val();
					$('input[name="start"]', form).val(length * (target - 1));
					form.submit();
				}
			},

			toggleFacetVisibility: function() {
				var isExpanded = $(this).attr('aria-expanded') === 'true';
				var data = $(this).data();
				$(this).text(isExpanded ? data.amsLessLabel : data.amsMoreLabel);
			    $(this).blur();
			},

			updateUrlWithCheckedFilters: function() {
				var urlParams = new URLSearchParams(window.location.search);
				var filterTypes = new Set($('input[name="filter"], select[name="filter"]').map(function () {
					return $(this).data('filter-type');
				}).get());
				filterTypes.forEach(type => urlParams.delete(type));
				$('input[name="filter"]:checked, select[name="filter"]').each(function () {
					var filterType = $(this).data('filter-type');
					var value = $(this).val();
					// Append each selected filter value under its respective filter type
					if (value) {
						urlParams.append(filterType, value);
					}
				});
				// Construct the new URL with updated parameters
				window.location.href = `${window.location.protocol}//${window.location.host}${window.location.pathname}?${urlParams.toString()}`;
			}
		},

		/**
		 * Forms management
		 */
		form: {

			autoSubmit: function(evt) {
				$(evt.target).parents('form').submit();
			},

			resetFilters: function(evt){
				var form = $("#recherche-filters");
				$('input[type="text"]', form).val('');
				$('input[name="filter"]', form).prop('checked', false);
				$('select[name="filter"]', form).prop('selectedIndex', 0);
				if ($.fn.select2) {
					$('.select2', form).select2('val', null);
				}
				ONF.search.updateUrlWithCheckedFilters();
			},

			resetAndSubmit: function(evt) {
				var form = $(evt.target).parents('form');
				$('input[type="text"]', form).each(function(idx, elt) {
					$(elt).val('');
				});
				$('.select2', form).each(function(idx, elt) {
					$(elt).select2('val', null);
				});
				form.submit();
			},

			submitHandler: function(form, event) {

				function doSubmit(form) {
					var button = $('button[type="submit"]', form),
						name = button.attr('name'),
						input = $('input[name="' + name + '"]', form);
					if (!input.exists()) {
						$('<input />').attr('type', 'hidden')
									  .attr('name', name)
									  .attr('value', button.attr('value'))
									  .appendTo(form);
					}
					form.submit();
				}

				if (window.grecaptcha) {  // check if recaptcha was loaded
					var captcha_key = $(form).data('ams-form-captcha-key');
					grecaptcha.execute(captcha_key, {action: 'form_submit'}).then(function(token) {
						$('.state-error', form).removeClass('state-error');
						$('input[name="g-recaptcha-response"]', form).val(token);
						doSubmit(form);
					});
				} else {
					doSubmit(form);
				}
			}
		},

		/**
		 * Live forests management
		 */
		live: {

			updateContentType: function(evt) {
				var button = $(evt.target),
					contentType = button.attr('aria-checked') === 'false' ? 'activity' : 'forest',
					form = $('form[id="recherche-results"]'),
					userSearch = $('input[name="user_search"]', form).val(),
					display = $('input[name="display"]', form).val(),
					displayType = display.substring(1,2) === 'l' ? 'l' : 'm';
				window.location = `${form.attr('action')}?content_type=${contentType}&` +
					`display=${contentType.substring(0,1)}${displayType}&start=0&user_search=${userSearch}`;
			},

			showActiveMarker: function(evt) {
				var target = $('.spot', evt.currentTarget).data('targetmarker'),
					map = $('.ams-map'),
					marker = map.data('markers')[target];
				if (marker !== undefined) {
					marker.fire('mouseover', {scroll: false});
				}
			},

			hideActiveMarker: function(evt) {
				var target = $('.spot', evt.currentTarget).data('targetmarker'),
					map = $('.ams-map'),
					marker = map.data('markers')[target];
				if (marker !== undefined) {
					marker.fire('mouseout');
				}
			},

			enableAreaFilter: function(evt) {
				var searchForm = $('[id="recherche-results"]'),
					center = $('input[name="map_center"]', searchForm);
				if (center.exists()) {
					$('.opsmap__area_filter').removeClass('hidden');
				}
			},

			applyAreaFilter: function(evt) {
				var searchForm = $('[id="recherche-results"]'),
					center = $('input[name="map_center"]', searchForm);
				if (center.exists()) {
					var map = $('.ams-map').data('leafmap'),
						geo_center = map.getCenter();
					$('input[name="start"]', searchForm).val(0);
					center.val(`${geo_center.lng} ${geo_center.lat}`);
					searchForm.submit();
				}
			}
		}
	};

	/**
	 * Update main menus status
	 */
	$('.main-nav__link', '#menu-principal').each(function() {
		if (window.location.href.startsWith($(this).attr('data-ams-url') || '##')) {
			$(this).parents('li').first().addClass('main-nav__item--current');
		}
	});

	/**
	 * Native sharing handler
	 */
	if (navigator.share) {
		const regularShareWrapper = $('#regularShare');
		const nativeShareWrapper = $('#nativeShare');
		const shareBtn = $('#nativeShareButton');
		const shareResult = $('#nativeShareResult');

		const shareData = {
			title: $('title', 'head').text(),
			text: $('meta[name="description"]', 'head').attr('content'),
			url: $('meta[rel="canonical"]', 'head').attr('href')
		}

		shareBtn.on('click', async () => {
			try {
				await navigator.share(shareData);
				shareResult.text("Partage effectué !")
			} catch (err) {
				shareResult.text("'Une erreur s'est produite : " + err);
			}
		});

		regularShareWrapper.css('display', 'none');
		nativeShareWrapper.css('display', 'block');
	}

	/**
	 * Add wrapper to tables
	 */
	$('table', '.edito').wrap('<div class="table-wrapper"></div>');

	/**
	 * Update all external links target
	 */
	var base = window.location.protocol + '//' + window.location.host;
	$('a[href]').each(function() {
		var href = $(this).attr('href');
		if (!(href.startsWith('/') ||
			  href.startsWith('#') ||
			  href.startsWith('javascript:') ||
			  href.startsWith('mailto:') ||
			  href.startsWith(base))) {
			$(this).attr('target', '_blank');
		}
	});

	/**
	 * Update SVG images
	 */
	var svgs = $('.svg-container');
	if (svgs.length > 0) {
		svgs.each(function() {
			var container = $(this);
			var svg = $('svg', container),
				width = svg.attr('width'),
				height = svg.attr('height');
			if (width && height) {
				svg.get(0).setAttribute('viewBox',
										'0 0 ' + Math.round(parseFloat(width)) + ' ' +
												 Math.round(parseFloat(height)));
			}
			svg.attr('width', '100%')
			   .attr('height', 'auto')
			   .removeAttr('preserveAspectRatio');
		})
	}

	/**
	 * Home page video player button
	 */
	var videoBg = $('#homebannerVideoBg');
	if (videoBg.length > 0) {
		var button = $('#videoBgButton');
		var buttonText = $('#videoBgButtonTxt');

		button.on('click', function (e) {
			if (buttonText.hasClass('playing')) {
				videoBg.get(0).pause();
				button.removeClass('homebanner__videoBtn--paused');
				buttonText.removeClass('playing')
						  .text(buttonText.data('onf-play-text'));
			} else {
				videoBg.get(0).play();
				button.addClass('homebanner__videoBtn--paused');
				buttonText.addClass('playing')
						  .text(buttonText.data('onf-stop-text'));
			}
		});
	}


	// Initialize Masonry
	var msnry;
	var grid = $('.masonry-layout > .portlets');
	if (grid.exists()) {
		ams.require(['error', 'ajax'], function() {
			ams.ajax.check([$.fn.masonry, $.fn.imagesLoaded], [
				'/--static--/onf_website/plugins/masonry.pkgd.min.js',
				'/--static--/onf_website/plugins/imagesloaded.pkgd.min.js'
			], function() {

				var masonryGrid = function() {
					var w = Math.max(
						document.documentElement.clientWidth,
						window.innerWidth || 0
					);
					if (w >= 1035 && !msnry) {
						msnry = grid.masonry({
							itemSelector: '.portlet',
							columnWidth: '.grid-sizer',
							percentPosition: true,
							horizontalOrder: false
						})
					} else if (w < 1035 && msnry) {
						msnry = Masonry.data(grid);
						msnry.destroy();
						msnry = null;
					}
					// Reload Facebook
					if (typeof FB !== 'undefined') {
						FB.XFBML.parse();
					}
				}

				grid.imagesLoaded(masonryGrid);
				window.addEventListener('resize', masonryGrid);
			});
		});
	}


	// Videos sources updates
	//
	// Update videos sources based on current screen resolution
	function resetVideosSources() {
		var videos = $('video');
		if (videos.length > 0) {
			var width;
			if (window.matchMedia === undefined) {
				width = (window.innerWidth > 0) ? window.innerWidth : screen.width
			}
			videos.each(function(idx, elt) {
				var video = $(elt),
					position = elt.currentTime || 0,
					sources = video.data('ams-sources'),
					loaded = {};
				if (sources) {
					video.empty();
					for (var idxSrc in sources) {
						if (!sources.hasOwnProperty(idxSrc)) {
							continue;
						}
						var source = sources[idxSrc],
							type = source.type,
							condition;
						if (loaded[type] !== undefined) {
							continue;
						}
						if (window.matchMedia === undefined) {
							condition = (source.min < width);
							if (condition && source.max) {
								condition = (width <= source.max);
							}
						} else {
							var min = source.min ? '(min-device-width: ' + source.min + 'px)' : '',
								max = source.max ? '(max-device-width: ' + source.max + 'px)' : '',
								query = min + ((min && max) ? ' and ' : '') + max;
							condition = window.matchMedia(query).matches;
						}
						if (condition) {
							$('<source>').attr('type', type)
								.attr('src', source.src)
								.appendTo(video);
							loaded[type] = true;
						}
					}
					elt.currentTime = position;
				}
			});
		}
	}
	resetVideosSources();
	window.addEventListener('resize', resetVideosSources);


	// Initialize main events handlers
	ams.initHandlers(document);


	// Download custom MyAMS modules to handle forms
	ams.require(['plugins-loader'], function () {
		ams.plugins.initData(document);

		// Create rellax extension
		if ($('.rellax', document).exists()) {
			var rellax = new Rellax('.rellax', {
				breakpoints: [720, 990, 1290]
			});
		}
		if ($.fn.tilt) {
			$('[data-tilt]').tilt();
		}

		// Initiate gallery grids
		if (window.MagicGrid) {
			$('.gallery-grid').each((idx, elt) => {
				var magicGrid = new MagicGrid({
					container: elt,
					animate: true,
					gutter: 0,
					static: true,
					useMin: true
				});
				magicGrid.listen();
			});
		}

		// Initialize BaguetteBox
		if (window.baguetteBox) {
			$('.gallery').each((idx, elt) => {
				var gallery = $(elt),
					galleryId = `#${gallery.attr('id')}`;
				var box = baguetteBox.run(galleryId, {
					captions: function(element) {
						var img;
						element = $(element);
						if (element.hasClass('zoom')) {
							img = $('img', element.siblings('picture'));
						} else {
							img = $('img', element);
						}
						var title = img.data('title') || img.attr('alt') || '',
							copyright = img.data('copyright') || '';
						return '<span class="d-block px-3">' + title + ((title && copyright) ? ' - ' : '') + (copyright ? ('<span class="legend__copyright">' + copyright + '</span>') : '') + '</span>';
					}
				});
				$('a.zoom', gallery).on('click', (evt) => {
					baguetteBox.show(0, box[0]);
					return false;
				});
			});
		}

		// Init forms
		var forms = $('form.ams-form', document);
		if (forms.exists()) {
			ams.require(['error', 'ajax', 'form', 'events', 'helpers', 'i18n'], function () {
				var required = ['plugins'];
				var html = $('html');
				var lang = html.attr('lang') || html.attr('xml:lang');
				if (lang && !lang.startsWith('en')) {
					ams.lang = lang;
					required.push(ams.baseURL + 'i18n/myams_' + lang.substr(0, 2) + ams.devext + '.js');
				}
				ams.require(required, function() {
					ams.getCSS('/--static--/pyams_default_theme/css/select2.css', 'pyams_select2', function() {
						ams.form.init(document);
						ams.plugins.init(document);
						ams.events.init(document);
					});
				});
			});
		}
	});

	// Download custom MyAMS modules to handle maps
	var maps = $('div.ams-map', document);
	if (maps.exists()) {
		ams.require([
			'error', 'ajax'
		], function() {
			ams.require([
				window.location.protocol + '//' + window.location.host + '/--static--/pyams_gis/js/pyams_gis.js'
			], function() {
				PyAMS_GIS.init(maps, {}, null, function() {
					PyAMS_GIS.markers.init(maps);
					// init events handlers
					setTimeout(function() {
						maps.each((idx, map) => {
							var data = $(map).data(),
								handlers = data.mapEventsHandlers;
							if (handlers) {
								for (var event in handlers) {
									if (handlers.hasOwnProperty(event)) {
										data.leafmap.on(event, MyAMS.getFunctionByName(handlers[event]));
									}
								}
							}
						});
					}, 1000);
				});
			});
		});
	}

})(jQuery, this);
