(function ($) {

  // + --------------------------------------------
  /*! hilight current item */
  var fnSecondaryNavHilight = function (nav) {
    'use strict';

    var $nav = nav,
    $navItem = $nav.find('a[href^="#"]');

    $navItem.each(function () {

      var $current = jQuery(this),
            $cible = jQuery($current.attr('href'));

      $cible.waypoint(function (direction) {
        if (direction === 'down') {
          $navItem.parent().removeClass('active');
          $current.parent().addClass('active');
        }
        //hilightForMobile($current);
      }, {
        offset: 110
      });

      $cible.waypoint(function (direction) {
        if (direction === 'up') {
          $navItem.parent().removeClass('active');
          $current.parent().addClass('active');
        }
        //hilightForMobile($current);
      }, {
        offset: -50
      });

    });

    // var hilightForMobile = function (el) {
    //   var activeLinkHTML = jQuery(el).html();
    //   $nav.find('.selected__inner').html(activeLinkHTML);
    // };

  };

  /*! side menu fx */
  var fnSecondaryNav = function () {
    'use strict';

    var $nav          = jQuery('.article-aside__toc-menu'),
        navLink       = 'a[href^="#"]',
        $trigger      = $nav.find('.toggle-nav');

    var bindAction = function () {

      $nav.on('click', navLink, function () {

        var target = jQuery(this).attr('href'),
               top = jQuery(target).offset().top - 90;

        $trigger.removeClass('active');

        jQuery('html, body').stop().animate({
          scrollTop: top
        }, 500 );

        // if(jQuery(this).closest('ol').hasClass('active')) {
        //   jQuery(this).closest('.active').removeClass('active');
        // }

        return false;

      });

    };

    var hilightFx = function () {
      fnSecondaryNavHilight($nav);
    };

    return {

      reload: function () {
        if ($nav.length) {
          hilightFx();
        }
      },

      init: function () {
        if ($nav.length) {
          bindAction();
          hilightFx();
        }
      }

    };

  }();

  fnSecondaryNav.init();

}(jQuery));
