(function ($) {

	Date.prototype.addHours = function (h) {
		return new Date(this.valueOf() + 86400000 * (h / 24));
	};

	var localStoredName = 'alerted::',
		wrapper = $('#alertBanner'),
		closeButton = $('#alertBannerClose');

	/**
	 * Check for visible alerts
	 * Hide alerts wrapper if none
	 */
	var checkVisibleAlerts = function() {

		if ($('.alert:visible').length === 0) {
			$('body').removeClass('alert--enabled');
			wrapper.removeClass('wrapper-alert--enabled');
			wrapper.attr('aria-hidden', true);
		}
	};

	/**
	 * Check each alert
	 * Alert is displayed if never checked or if maximum internal is passed
	 */
	var checkAlerts = function () {

		var carousel = $('.owl-carousel', wrapper).owlCarousel(),
			carouselInstance = carousel.data('owl.carousel');

		$('.alert-item', '.owl-carousel-alert').each(function() {
			var alert = $(this),
				item = alert.parents('.owl-item'),
				storageKey = localStoredName + alert.data('alert-id'),
				alerted_on = localStorage.getItem(storageKey);
			if (alerted_on) {
				alerted_on = new Date(alerted_on);
				var now = new Date(),
					hide_until = alerted_on.addHours(parseInt(alert.data('alert-maximum-interval')));
				if (hide_until > now) {  // Hide alert
					carouselInstance.remove(item.index());
				}
			}
		});

		if (carouselInstance) {
			carouselInstance.refresh();
		}
		checkVisibleAlerts();

	};

	/**
	 * Hide active alert
	 */
	closeButton.on('click', function (event) {

		event.preventDefault();

		var carousel = $('.owl-carousel', wrapper).owlCarousel(),
			carouselInstance = carousel.data('owl.carousel'),
			item = $('.active', '.owl-carousel-alert'),
			alert = $('[data-alert-id]', item),
			storageKey = localStoredName + alert.data('alert-id');

		carouselInstance.remove(item.index());
		carouselInstance.refresh();
		localStorage.setItem(storageKey, (new Date()).toISOString());

		checkVisibleAlerts();

	});

	// get alerted preference from localStorage
	checkAlerts();

})(jQuery);
