#
# Copyright (c) 2008-2019 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import Interface

from onf_website.skin.public.patronage import IONFPatronageLayer
from onf_website.skin.public.viewlet.banner import SiteRootBanner
from pyams_content.root.interfaces import ISiteRoot
from pyams_content.shared.site.interfaces import ISiteManager
from pyams_template.template import template_config
from pyams_viewlet.viewlet import contentprovider_config


__docformat__ = 'restructuredtext'


@contentprovider_config(name='pyams.banner', context=ISiteRoot, layer=IONFPatronageLayer,
                        view=Interface)
@contentprovider_config(name='pyams.banner', context=ISiteManager, layer=IONFPatronageLayer,
                        view=Interface)
@template_config(template='templates/siteroot-banner.pt', layer=IONFPatronageLayer)
class PatronageSiteBanner(SiteRootBanner):
    """Internal site banner"""
