#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import Interface

from onf_website.skin.public import onf_base_skin
from pyams_default_theme.layer import IPyAMSDefaultLayer
from pyams_default_theme.page import BaseIndexPage, BasePreviewPage
from pyams_default_theme.shared.form import FormFieldContainerInputForm
from pyams_skin.interfaces.resources import IResources
from pyams_template.template import override_layout, override_template
from pyams_utils.adapter import ContextRequestViewAdapter, adapter_config


__docformat__ = 'restructuredtext'


class IONFBaseLayer(IPyAMSDefaultLayer):
    """ONF base skin layer"""


class IONFSatelliteLayer(IONFBaseLayer):
    """ONF satellite site skin layer"""


override_layout(context=BaseIndexPage, layer=IONFBaseLayer,
                template='templates/layout.pt')
override_layout(context=BasePreviewPage, layer=IONFBaseLayer,
                template='templates/preview-layout.pt')


override_template(context=FormFieldContainerInputForm, layer=IONFBaseLayer,
                  template='templates/form.pt')


@adapter_config(context=(Interface, IONFBaseLayer, Interface),
                provides=IResources)
class ONFBaseLayerResourcesAdapter(ContextRequestViewAdapter):
    """Base layer resources adapter"""

    resources = (onf_base_skin,)
