#
# Copyright (c) 2008-2019 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import Interface

from onf_website.skin.public import onf_internal_skin
from onf_website.skin.public.layer import IONFBaseLayer
from pyams_skin.interfaces import ISkin
from pyams_skin.interfaces.resources import IResources
from pyams_utils.adapter import adapter_config, ContextRequestViewAdapter
from pyams_utils.registry import utility_config


__docformat__ = 'restructuredtext'

from onf_website import _


class IONFInternalLayer(IONFBaseLayer):
    """ONF internal skin layer"""


@utility_config(name='ONF internal skin', provides=ISkin)
class ONFInternalSkin(object):
    """ONF internal skin"""

    label = _("ONF: internal site skin")
    layer = IONFInternalLayer


@adapter_config(context=(Interface, IONFInternalLayer, Interface), provides=IResources)
class ONFInternalLayerResourcesAdapter(ContextRequestViewAdapter):
    """Internal layer resources adapter"""

    resources = (onf_internal_skin,)
