#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import Attribute, Interface
from zope.schema import Bool, Choice, Int, TextLine

from pyams_default_theme.features.search.portlet.interfaces import FULL_HEADER_DISPLAY, \
    PANELS_HEADER_DISPLAY_MODES_VOCABULARY
from pyams_file.schema import FileField
from pyams_gis.interfaces.configuration import IMapConfiguration
from pyams_i18n.schema import I18nTextField, I18nTextLineField
from pyams_sequence.schema import InternalReferenceField


__docformat__ = 'restructuredtext'

from onf_website import _


class IONFViewItemsPortletBaseRendererSettings(Interface):
    """ONF view items portlet base renderer settings"""

    list_reference = InternalReferenceField(title=_("'All news' reference"),
                                            description=_("Internal reference to site or folder "
                                                          "displaying full list of view's "
                                                          "contents"),
                                            required=False)

    def get_target(self):
        """Get internal reference target"""

    link_label = I18nTextLineField(title=_("Link label"),
                                   description=_("Label of link to full list page"),
                                   required=False)

    include_context_settings = Bool(title=_("Include context settings"),
                                    description=_("If 'yes', context settings based on location "
                                                  "will be added to target URL"),
                                    required=True,
                                    default=False)


class IONFViewItemsPortletNewsRendererSettings(IONFViewItemsPortletBaseRendererSettings):
    """View items portlet news renderer settings interface"""

    header_results = Int(title=_("Header results count"),
                         description=_("This is the number of view items which will be displayed "
                                       "in full width"),
                         required=True,
                         default=1)

    highlight_results = Int(title=_("Highlighted results count"),
                            description=_("This is the number of view items which will be "
                                          "\"highlighted\" and displayed in a specific way"),
                            required=False,
                            default=0)

    main_css_class = TextLine(title=_("Main CSS class"),
                              description=_("CSS class associated with the main block"),
                              required=True,
                              default='col-lg-10 col-lg-offset-1')

    inner_css_class = TextLine(title=_("Inner CSS class"),
                               description=_("CSS class associated with inner blocks"),
                               required=True,
                               default='col-sm-6 col-md-4')


class IONFViewItemsPortletNewsTightRendererSettings(IONFViewItemsPortletBaseRendererSettings):
    """View items portlet news tight renderer settings interface"""

    main_css_class = TextLine(title=_("Main CSS class"),
                              description=_("CSS class associated with the main block"),
                              required=True,
                              default='col-sm-6 col-md-8')

    inner_css_class = TextLine(title=_("Inner CSS class"),
                               description=_("CSS class associated with inner blocks"),
                               required=True,
                               default='col-md-6')


class IONFViewItemsPortletHalfWidthRendererSettings(IONFViewItemsPortletBaseRendererSettings):
    """Half-width view items portlet renderer settings interface"""

    empty_message = I18nTextField(title=_("Empty list message"),
                                  description=_("This message will be displayed inside view "
                                                "if no result is found"),
                                  required=False)

    empty_link_label = I18nTextLineField(title=_("Empty link label"),
                                         description=_("This label will be displayed as link "
                                                       "label when ths list is empty"),
                                         required=False)


class IONFViewItemsPortletActivitiesRendererSettings(IONFViewItemsPortletBaseRendererSettings):
    """Activities view items portlet renderer settings interface"""


class IONFViewItemsPortletAssociatedRendererSettings(IONFViewItemsPortletBaseRendererSettings):
    """Associated links view items portlet renderer settings interface"""


class IONFViewItemsPortletTexturedRendererSettings(IONFViewItemsPortletBaseRendererSettings):
    """Textured links view items portlet renderer settings interface"""

    intro_text = I18nTextField(title=_("Introduction text"),
                               description=_("Introduction text displayed by front-office "
                                             "template"),
                               required=False)


class IONFViewItemsPortletFramedRendererSettings(IONFViewItemsPortletBaseRendererSettings):
    """Framed links view items portlet renderer settings interface"""

    intro_text = I18nTextField(title=_("Introduction text"),
                               description=_("Introduction text displayed by front-office "
                                             "template"),
                               required=False)

    frame_title = I18nTextLineField(title=_("Frame title"),
                                    description=_("Frame title displayed by front-office "
                                                  "template"),
                                    required=False)

    frame_body = I18nTextField(title=_("Frame body"),
                               description=_("Frame body text displayed by front-office "
                                             "template"),
                               required=False)


class IONFViewItemsPortletPictogramsMarginRendererSettings(IONFViewItemsPortletBaseRendererSettings):
    """View items with pictograms and margin portlet renderer settings interface"""


class IONFViewItemsPortletCarouselRendererSettings(Interface):
    """View items portlet carousel renderer settings interface"""

    header = I18nTextField(title=_("Header"),
                           description=_("Menu header displayed by front-office template"),
                           required=False)

    button_label = I18nTextLineField(title=_("Button label"),
                                     description=_("Label of the navigation button displayed by "
                                                   "front-office template"),
                                     required=False)

    button_target = InternalReferenceField(title=_("Button target"),
                                           description=_("Internal reference to site or folder "
                                                         "targetted by button"),
                                           required=False)


class IONFViewItemsPortletSummaryRendererSettings(Interface):
    """View items portlet summary renderer settings interface"""

    header_display_mode = Choice(title=_("Header display mode"),
                                 description=_("Defines how results headers will be rendered"),
                                 required=True,
                                 vocabulary=PANELS_HEADER_DISPLAY_MODES_VOCABULARY,
                                 default=FULL_HEADER_DISPLAY)

    start_length = Int(title=_("Start length"),
                       description=_("If you choose to display only header start, you can "
                                     "specify maximum text length"),
                       required=True,
                       default=120)

    button_label = I18nTextLineField(title=_("Button label"),
                                     description=_("Label of the navigation button displayed by "
                                                   "front-office template"),
                                     required=False)


class IONFViewItemsPortletResourcesRendererSettings(Interface):
    """View items portlet resources renderer settings interface"""


class IONFViewItemsPortletMapRendererSettings(IMapConfiguration):
    """View items portlet map renderer settings interface"""

    no_use_default_map_configuration = Bool(title=_("Don't use default configuration?"),
                                            required=True,
                                            default=False)

    use_default_map_configuration = Bool(title=_("Use default configuration?"),
                                         required=True,
                                         default=True)

    configuration = Attribute("Map configuration")

    map_height = Int(title=_("Map height"),
                     description=_("Max height, given in pixels"),
                     required=True,
                     default=400)

    display_illustrations = Bool(title=_("Display illustrations?"),
                                 description=_("If 'yes', illustrations associated to "
                                               "search results will be displayed in "
                                               "markers tooltips"),
                                 required=True,
                                 default=True)

    marker_image = FileField(title=_("Custom marker image"),
                             description=_("This image will replace default marker..."),
                             required=False)

    display_clusters = Bool(title=_("Show markers groups"),
                            description=_("If 'yes', location markers will be grouped in "
                                          "clusters at higher map scale"),
                            required=True,
                            default=True)
