#
# Copyright (c) 2015-2020 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""ONF_website.shared.site.skin.interfaces module

"""

from zope.interface import Interface
from zope.schema import Choice, Int, Set, TextLine

from pyams_default_theme.features.search.portlet import FULL_HEADER_DISPLAY
from pyams_default_theme.features.search.portlet.interfaces import \
    PANELS_HEADER_DISPLAY_MODES_VOCABULARY


__docformat__ = 'restructuredtext'

from onf_website import _


class ISiteContainerSummaryPortletAccordionRendererSettings(Interface):
    """Site container summary portlet accordion renderer settings interface"""

    folders = Set(title=_("Selected folders"),
                  description=_("List of selected folders; an empty selection means that all "
                                "visible site folders will be selectable; otherwise, this "
                                "selection will have priority"),
                  value_type=Choice(vocabulary="PyAMS site contents"),
                  required=False)

    opened_folders = Set(title=_("Opened folders"),
                         description=_("List of selected folders; an empty selection means that "
                                       "all visible site folders will be selectable; otherwise, "
                                       "this selection will have priority"),
                         value_type=Choice(vocabulary="PyAMS site contents"),
                         required=False)

    inner_css_class = TextLine(title=_("Inner CSS class"),
                               description=_("CSS class associated with inner blocks"),
                               required=True,
                               default='col-sm-6 col-md-4')

    header_display_mode = Choice(title=_("Header display mode"),
                                 description=_("Defines how contents headers will be rendered"),
                                 required=True,
                                 vocabulary=PANELS_HEADER_DISPLAY_MODES_VOCABULARY,
                                 default=FULL_HEADER_DISPLAY)

    max_header_length = Int(title=_("Header length"),
                            description=_("If you choose to display only header start, you can "
                                          "specify maximum text length"),
                            required=True,
                            default=120)
