#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import classImplements

from onf_website.component.hearing.interfaces import IHearingManagerTarget, IHearingTarget
from onf_website.shared.common.security import SharedToolManagerRestrictionInfo
from pyams_content.component.gallery import IGalleryTarget
from pyams_content.shared.common.interfaces import IManagerRestrictionsFactory
from pyams_content.shared.site import WfSiteTopic
from pyams_content.shared.site.folder import SiteFolder
from pyams_content.shared.site.interfaces import ISiteContainer
from pyams_content.shared.site.manager import SiteManager
from pyams_utils.adapter import adapter_config


#
# Topics interfaces
#

classImplements(WfSiteTopic, IHearingTarget)

#
# Site folder interfaces
#

classImplements(SiteFolder, IHearingTarget)

#
# Site manager interfaces
#

classImplements(SiteManager, IGalleryTarget)

classImplements(SiteManager, IHearingManagerTarget)
classImplements(SiteManager, IHearingTarget)


@adapter_config(context=ISiteContainer, provides=IManagerRestrictionsFactory)
def site_container_restrictions_factory(context):
    """Site container restrictions factory"""
    return SharedToolManagerRestrictionInfo
