#
# Copyright (c) 2008-2017 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from pyramid.events import subscriber
from zope.component.interfaces import ISite
from zope.interface import implementer
from zope.lifecycleevent.interfaces import IObjectAddedEvent
from zope.schema.fieldproperty import FieldProperty

from onf_website.component.hearing.interfaces import IHearingManagerTarget
from onf_website.component.location.interfaces import ILocationManagerTarget
from onf_website.shared.common.security import SharedToolManagerRestrictionInfo
from onf_website.shared.service import Service
from onf_website.shared.service.interfaces import IServiceManager, IServiceManagerFactory, SERVICE_CONTENT_TYPE
from pyams_content.component.paragraph.interfaces import IParagraphFactorySettings
from pyams_content.component.theme.interfaces import IThemesManagerTarget
from pyams_content.reference.pictograms.interfaces import IPictogramManagerTarget
from pyams_content.shared.common.interfaces import IManagerRestrictionsFactory, ISharedContentFactory
from pyams_content.shared.common.manager import SharedTool
from pyams_utils.adapter import adapter_config
from pyams_utils.registry import utility_config
from pyams_utils.traversing import get_parent


@implementer(IServiceManager, IParagraphFactorySettings, ILocationManagerTarget, IHearingManagerTarget,
             IPictogramManagerTarget, IThemesManagerTarget)
class ServiceManager(SharedTool):
    """Service manager class"""

    shared_content_type = SERVICE_CONTENT_TYPE

    allowed_paragraphs = FieldProperty(IParagraphFactorySettings['allowed_paragraphs'])
    auto_created_paragraphs = FieldProperty(IParagraphFactorySettings['auto_created_paragraphs'])


@utility_config(provides=IServiceManagerFactory)
class ServiceManagerFactory(object):
    """Service manager factory"""

    def __new__(cls):
        return ServiceManager


@adapter_config(context=IServiceManager, provides=IManagerRestrictionsFactory)
def service_manager_restrictions_factory(context):
    """Service manager custom restrictions factory"""
    return SharedToolManagerRestrictionInfo


@adapter_config(context=IServiceManager, provides=ISharedContentFactory)
def service_manager_content_factory(context):
    return Service


@subscriber(IObjectAddedEvent, context_selector=IServiceManager)
def handle_added_service_manager(event):
    """Register service manager when added"""
    site = get_parent(event.newParent, ISite)
    registry = site.getSiteManager()
    if registry is not None:
        registry.registerUtility(event.object, IServiceManager)
