#
# Copyright (c) 2008-2017 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Interface

from onf_website import _
from pyams_content.shared.common.interfaces import ISharedContent, ISharedToolPortalContext, \
    IWfSharedContentPortalContext
from pyams_content.shared.logo import LOGO_CONTENT_TYPE
from pyams_i18n.schema import I18nTextField, I18nTextLineField
from pyams_sequence.interfaces import IInternalReferencesList
from pyams_sequence.schema import InternalReferencesListField


SERVICE_CONTENT_TYPE = 'service'
SERVICE_CONTENT_NAME = _("Service delivery")


class IServiceManager(ISharedToolPortalContext):
    """Service delivery manager interface"""


class IServiceManagerFactory(Interface):
    """Service delivery manager factory interface"""


class IWfServiceInfo(Interface):
    """Service delivery custom attributes interface"""

    client_wish_header = I18nTextLineField(title=_("Client wishes header"),
                                           required=False)

    client_wish = I18nTextField(title=_("Client wishes"),
                                description=_("List of possible client wishes; please enter items "
                                              "on separated lines"),
                                required=False)

    provider_assets_header = I18nTextLineField(title=_("Provider assets header"),
                                               required=False)

    provider_assets = I18nTextField(title=_("Provider assets"),
                                    description=_("List of provider assets; please enter items on "
                                                  "separated lines"),
                                    required=False)

    logos = InternalReferencesListField(title=_("Clients logos"),
                                        description=_("Logos list of partners who subscribed to "
                                                      "this service"),
                                        content_type=LOGO_CONTENT_TYPE,
                                        required=False)

    def get_logos(self, state=None):
        """Get logos from internal references"""


class IWfService(IWfSharedContentPortalContext, IWfServiceInfo, IInternalReferencesList):
    """Service delivery interface"""


class IWfServiceFactory(Interface):
    """Service delivery factory interface"""


class IService(ISharedContent):
    """Workflow managed service delivery interface"""
