#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import classImplements

from onf_website.component.hearing import IHearingTarget
from onf_website.component.hearing.interfaces import IHearingManagerTarget
from onf_website.component.location import ILocationManagerTarget, ILocationTarget
from onf_website.shared.common.security import SharedToolManagerRestrictionInfo
from pyams_content.shared.common.interfaces import IManagerRestrictionsFactory
from pyams_content.shared.resource import WfResource
from pyams_content.shared.resource.interfaces import IResourceManager
from pyams_content.shared.resource.manager import ResourceManager
from pyams_utils.adapter import adapter_config

#
# Add interfaces to base classes
#

classImplements(ResourceManager, ILocationManagerTarget)
classImplements(ResourceManager, IHearingManagerTarget)

classImplements(WfResource, ILocationTarget)
classImplements(WfResource, IHearingTarget)


@adapter_config(context=IResourceManager, provides=IManagerRestrictionsFactory)
def resource_manager_restrictions_factory(context):
    """Resource manager custom restrictions factory"""
    return SharedToolManagerRestrictionInfo
