#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from onf_website.shared.report.interfaces import IWfReport, IReportManager
from pyams_content.interfaces import CREATE_CONTENT_PERMISSION
from pyams_i18n.interfaces import II18n
from pyams_skin.interfaces import IContentTitle
from pyams_skin.interfaces.viewlet import IMenuHeader, IWidgetTitleViewletManager
from pyams_skin.layer import IPyAMSLayer
from pyams_zmi.interfaces.menu import IContentManagementMenu
from pyams_zmi.layer import IAdminLayer

# import packages
from pyams_content.shared.common.zmi import SharedContentAJAXAddForm
from pyams_content.shared.common.zmi.types import TypedSharedContentAddForm
from pyams_form.form import ajax_config
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.viewlet.toolbar import ToolbarAction
from pyams_utils.adapter import adapter_config, ContextRequestAdapter, ContextRequestViewAdapter
from pyams_viewlet.viewlet import viewlet_config
from zope.interface import Interface

from onf_website import _


@adapter_config(context=(IWfReport, IContentManagementMenu), provides=IMenuHeader)
class ReportContentMenuHeader(ContextRequestAdapter):
    """Report content menu header adapter"""

    header = _("This report")


@adapter_config(context=(IWfReport, IPyAMSLayer, Interface), provides=IContentTitle)
class ReportTitleAdapter(ContextRequestViewAdapter):
    """Report title adapter"""

    @property
    def title(self):
        translate = self.request.localizer.translate
        return translate(_("Report « {title} »")).format(
            title=II18n(self.context).query_attribute('title', request=self.request))


@viewlet_config(name='add-shared-content.action', context=IReportManager, layer=IAdminLayer, view=Interface,
                manager=IWidgetTitleViewletManager, permission=CREATE_CONTENT_PERMISSION, weight=1)
class ReportAddAction(ToolbarAction):
    """Report adding action"""

    label = _("Add report")
    label_css_class = 'fa fa-fw fa-plus'
    url = 'add-shared-content.html'
    modal_target = True


@pagelet_config(name='add-shared-content.html', context=IReportManager, layer=IPyAMSLayer,
                permission=CREATE_CONTENT_PERMISSION)
@ajax_config(name='add-shared-content.json', context=IReportManager, request_type=IPyAMSLayer,
             permission=CREATE_CONTENT_PERMISSION, base=SharedContentAJAXAddForm)
class ReportAddForm(TypedSharedContentAddForm):
    """Report add form"""

    legend = _("Add report")
