#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import implementer, provider
from zope.schema.fieldproperty import FieldProperty

from onf_website.component.hearing import IHearingTarget
from onf_website.component.location import ILocationTarget
from onf_website.shared.press.interfaces import IPress, IWfPress, IWfPressFactory, \
    PRESS_CONTENT_NAME, PRESS_CONTENT_TYPE
from pyams_content.component.illustration.interfaces import IIllustrationTarget, \
    ILinkIllustrationTarget
from pyams_content.component.paragraph.interfaces import IParagraphContainerTarget
from pyams_content.component.theme.interfaces import ITagsTarget, IThemesTarget
from pyams_content.features.preview.interfaces import IPreviewTarget
from pyams_content.features.review.interfaces import IReviewTarget
from pyams_content.shared.common import SharedContent, WfSharedContent, register_content_type
from pyams_content.shared.common.interfaces import IWfSharedContentFactory
from pyams_content.shared.common.types import WfTypedSharedContentMixin
from pyams_utils.adapter import adapter_config


__docformat__ = 'restructuredtext'


@implementer(IWfPress, IIllustrationTarget, ILinkIllustrationTarget, IParagraphContainerTarget,
             ILocationTarget, IHearingTarget, ITagsTarget, IThemesTarget, IPreviewTarget, IReviewTarget)
class WfPress(WfSharedContent, WfTypedSharedContentMixin):
    """Base press release class"""

    content_type = PRESS_CONTENT_TYPE
    content_name = PRESS_CONTENT_NAME

    references = FieldProperty(IWfPress['references'])


register_content_type(WfPress)


@provider(IWfPressFactory)
@implementer(IPress)
class Press(SharedContent):
    """Workflow managed press release class"""


@adapter_config(context=IWfPressFactory, provides=IWfSharedContentFactory)
def topic_content_factory(context):
    return WfPress
