#
# Copyright (c) 2015-2022 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'

from onf_website.shared.planning import FakePlanning, IPlanningManager, IWfPlanning
from onf_website.skin.public.layer import IONFBaseLayer
from pyams_default_theme.features.search.portlet import ISearchResultHeader, \
    ISearchResultRenderer, WfSharedContentSearchResultRenderer
from pyams_default_theme.interfaces import ISearchResultsView
from pyams_i18n.interfaces import II18n
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_utils.registry import query_utility


@adapter_config(context=(IWfPlanning, IONFBaseLayer, ISearchResultsView),
                provides=ISearchResultRenderer)
@template_config(template='templates/search-result.pt', layer=IONFBaseLayer)
class WfPlanningSearchResultRenderer(WfSharedContentSearchResultRenderer):
    """Planning search result renderer"""


@adapter_config(context=(IWfPlanning, IONFBaseLayer, ISearchResultsView),
                provides=ISearchResultHeader)
def fake_planning_result_header_adapter(context, request, view):
    """Fake planning result header adapter"""
    header = II18n(context).query_attribute('header', request=request)
    if header:
        return header
    manager = query_utility(IPlanningManager)
    if manager is not None:
        return II18n(manager).query_attribute('default_header', request=request)
    return None
