#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from zope.schema.fieldproperty import FieldProperty

from onf_website.shared.planning.interfaces import IPlanningLinkPortletSettings
from pyams_portal.portlet import Portlet, PortletSettings, portlet_config
from pyams_utils.factory import factory_config
from pyams_utils.interfaces import VIEW_PERMISSION


__docformat__ = 'restructuredtext'

from onf_website import _


PLANNINGLINK_PORTLET_NAME = 'onf_website.portlet.planninglink'


@factory_config(provided=IPlanningLinkPortletSettings)
class PlanningLinkPortletSettings(PortletSettings):
    """Planning Link portlet settings"""

    title = FieldProperty(IPlanningLinkPortletSettings['title'])
    header = FieldProperty(IPlanningLinkPortletSettings['header'])


@portlet_config(permission=VIEW_PERMISSION)
class PlanningLinkPortlet(Portlet):
    """Planning Link portlet"""

    name = PLANNINGLINK_PORTLET_NAME
    label = _("Planning Link")

    toolbar_image = None
    toolbar_css_class = 'fa fa-fw fa-2x fa-search'

    settings_factory = IPlanningLinkPortletSettings

