#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Interface, implementer

from onf_website import _
from onf_website.shared.news.skin.interfaces import INewsSearchResultsView
from onf_website.skin.public.layer import IONFBaseLayer
from pyams_content.features.search.portlet import ISearchResultsPortletSettings
from pyams_content.shared.common import IWfSharedContent
from pyams_default_theme.features.search.portlet import ISearchResultRenderer, SearchResultsPortletDefaultRenderer, \
    WfSharedContentSearchResultRenderer
from pyams_portal.interfaces import IPortalContext, IPortletRenderer
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_utils.date import SH_DATE_FORMAT, format_date
from pyams_workflow.interfaces import IWorkflowPublicationInfo


@adapter_config(name='results-news',
                context=(IPortalContext, IPyAMSLayer, Interface, ISearchResultsPortletSettings),
                provides=IPortletRenderer)
@implementer(INewsSearchResultsView)
class SearchResultsPortletNewsRenderer(SearchResultsPortletDefaultRenderer):
    """Search results portlet news renderer"""

    label = _("News search results")
    weight = 10


@adapter_config(context=(IWfSharedContent, IONFBaseLayer, INewsSearchResultsView),
                provides=ISearchResultRenderer)
@template_config(template='templates/search-result.pt', layer=IONFBaseLayer)
class WfSharedContentSearchResultNewsRenderer(WfSharedContentSearchResultRenderer):
    """Shared content search result news renderer"""

    @property
    def publication_date(self):
        publication_date = IWorkflowPublicationInfo(self.context).visible_publication_date
        if publication_date:
            return format_date(publication_date, SH_DATE_FORMAT)
        return None
