#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from zope.interface import Interface

from onf_website.shared.common.skin.head import BaseHeaderPortletRenderer
from onf_website.skin.public.layer import IONFBaseLayer
from pyams_content.shared.common.portlet.interfaces import ISharedContentHeaderPortletSettings
from pyams_portal.interfaces import IPortalContext, IPortletRenderer
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config


__docformat__ = 'restructuredtext'

from onf_website import _


@adapter_config(name='ONF::head-news',
                context=(IPortalContext, IPyAMSLayer, Interface,
                         ISharedContentHeaderPortletSettings),
                provides=IPortletRenderer)
@template_config(template='templates/head-news.pt', layer=IONFBaseLayer)
class NewsHeaderPortletRenderer(BaseHeaderPortletRenderer):
    """News header portlet renderer"""

    label = _("ONF: News header with panoramic illustrations")
    weight = 20
