#
# Copyright (c) 2008-2017 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import Interface
from zope.schema import TextLine

from pyams_content.shared.common.interfaces import ISharedContent, ISharedToolPortalContext, \
    IWfSharedContentPortalContext
from pyams_file.schema import ImageField
from pyams_i18n.schema import I18nTextLineField
from pyams_sequence.interfaces import IInternalReferencesList


__docformat__ = 'restructuredtext'

from onf_website import _


INTERVIEW_CONTENT_TYPE = 'interview'
INTERVIEW_CONTENT_NAME = _("Interview")


class IInterviewManager(ISharedToolPortalContext):
    """Interview manager interface"""


class IInterviewManagerFactory(Interface):
    """Interview manager factory interface"""


class IWfInterviewInfo(Interface):
    """Interview custom attributes interface"""

    leading = I18nTextLineField(title=_("Leading text"),
                                description=_("Short content's leading"),
                                required=False)

    person_name = TextLine(title=_("Interviewed name"),
                           description=_("Name of the person being interviewed"),
                           required=False)

    portrait = ImageField(title=_("Portrait"),
                          description=_("Portrait of the person being interviewed"),
                          required=False)


class IWfInterview(IWfSharedContentPortalContext, IWfInterviewInfo, IInternalReferencesList):
    """Interview interface"""


class IWfInterviewFactory(Interface):
    """Interview factory interface"""


class IInterview(ISharedContent):
    """Workflow managed interview interface"""
