#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'

from zope.interface import Interface

from onf_website.shared.hunting import IHuntingCalendarInfo, IWfHuntingCalendar
from onf_website.skin.public.layer import IONFBaseLayer
from pyams_default_theme.shared.common.interfaces import ISharedContentHeadViewletManager
from pyams_template.template import template_config
from pyams_viewlet.viewlet import Viewlet, viewlet_config


@viewlet_config(name='hunting-head',
                context=IWfHuntingCalendar, layer=IONFBaseLayer, view=Interface,
                manager=ISharedContentHeadViewletManager, weight=1)
@template_config(template='templates/head-specificities.pt', layer=IONFBaseLayer)
class HuntingCalendarHeadViewlet(Viewlet):
    """Hunting calendar head viewlet"""

    @property
    def info(self):
        return IHuntingCalendarInfo(self.context)
