#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'

from zope.interface import Interface

from pyams_content.shared.common import ISharedContent
from pyams_content.shared.common.interfaces import ISharedToolPortalContext, \
    IWfSharedContentPortalContext
from pyams_i18n.schema import I18nTextLineField
from pyams_sequence.interfaces import IInternalReferencesList


from onf_website import _


HUNTING_CONTENT_TYPE = 'hunting'
HUNTING_CONTENT_NAME = _("Hunting calendar")


class IHuntingManager(ISharedToolPortalContext):
    """Hunting manager interface"""


class IHuntingManagerFactory(Interface):
    """Hunting manager factory interface"""


class IWfHuntingCalendar(IWfSharedContentPortalContext, IInternalReferencesList):
    """Hunting calendar content interface"""


class IWfHuntingCalendarFactory(Interface):
    """Hunting calendar factory interface"""


class IHuntingCalendar(ISharedContent):
    """Workflow managed hunting calendar interface"""


HUNTING_INFO_ANNOTATIONS_KEY = 'onf_website.hunting'


class IHuntingCalendarInfo(Interface):
    """Hunting calendar info interface"""

    season = I18nTextLineField(title=_("Season"),
                               description=_("Hunting calendar season"),
                               required=False)


