#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'

from persistent import Persistent
from zope.container.contained import Contained
from zope.interface import implementer, provider
from zope.schema.fieldproperty import FieldProperty

from onf_website.component.hearing import IHearingTarget
from onf_website.component.location import ILocationTarget
from onf_website.shared.hunting.interfaces import HUNTING_CONTENT_NAME, HUNTING_CONTENT_TYPE, \
    HUNTING_INFO_ANNOTATIONS_KEY, IHuntingCalendar, IHuntingCalendarInfo, IWfHuntingCalendar, \
    IWfHuntingCalendarFactory
from pyams_content.component.illustration import IIllustrationTarget, ILinkIllustrationTarget
from pyams_content.component.paragraph import IParagraphContainerTarget
from pyams_content.component.theme import ITagsTarget, IThemesTarget
from pyams_content.features.preview.interfaces import IPreviewTarget
from pyams_content.features.review import IReviewTarget
from pyams_content.shared.common import IWfSharedContentFactory, SharedContent, WfSharedContent, \
    register_content_type
from pyams_utils.adapter import adapter_config, get_annotation_adapter
from pyams_utils.factory import factory_config


@factory_config(IWfHuntingCalendar)
@implementer(IWfHuntingCalendar, IIllustrationTarget, ILinkIllustrationTarget,
             IParagraphContainerTarget, ILocationTarget, IHearingTarget, ITagsTarget,
             IThemesTarget, IPreviewTarget, IReviewTarget)
class WfHuntingCalendar(WfSharedContent):
    """Hunting calendar class"""

    content_type = HUNTING_CONTENT_TYPE
    content_name = HUNTING_CONTENT_NAME

    references = FieldProperty(IWfHuntingCalendar['references'])


register_content_type(WfHuntingCalendar)


@factory_config(IHuntingCalendarInfo)
class HuntingCalendarInfo(Persistent, Contained):
    """Hunting calendar persistent information"""

    season = FieldProperty(IHuntingCalendarInfo['season'])


@adapter_config(context=IWfHuntingCalendar, provides=IHuntingCalendarInfo)
def hunting_calendar_info_factory(context):
    """Hunting calendar info factory"""
    return get_annotation_adapter(context, HUNTING_INFO_ANNOTATIONS_KEY, IHuntingCalendarInfo,
                                  name='++info++')


@provider(IWfHuntingCalendarFactory)
@implementer(IHuntingCalendar)
class HuntingCalendar(SharedContent):
    """Workflow managed activity"""


@adapter_config(context=IWfHuntingCalendarFactory, provides=IWfSharedContentFactory)
def hunting_calendar_content_factory(context):
    return WfHuntingCalendar
