#
# Copyright (c) 2015-2022 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from zope.schema import Bool, Int

from onf_website.features.search.skin import IHeadFiltersSearchResultsPortletRendererSettings
from onf_website.features.search.skin.interfaces import \
    IMapWithHeadFiltersSearchResultsPortletRendererSettings
from pyams_i18n.schema import I18nTextField, I18nTextLineField


__docformat__ = 'restructuredtext'

from onf_website import _


class IForestsAndActivitiesMapSearchResultsPortletRendererSettings(
        IMapWithHeadFiltersSearchResultsPortletRendererSettings):
    """Forests and activities search results portlet renderer settings"""

    display_header = Bool(title=_("Display header"),
                          description=_("If 'no', header of search results will not be "
                                        "displayed"),
                          required=True,
                          default=True)

    search_distance = Int(title=_("Search distance"),
                          description=_("Search distance from map center, in kilometers"),
                          required=True,
                          default=25)

    display_distance = Bool(title=_("Display distance"),
                            description=_("If 'no', distance of search results from reference "
                                          "points will not be displayed"),
                            required=True,
                            default=True)

    distance_message = I18nTextLineField(title=_("Distance label format"),
                                         description=_("Format string used to display search "
                                                       "results distance from reference point; "
                                                       "use {} to include real distance value"),
                                         required=False)

    short_distance_length = Int(title=_("Short distance length"),
                                description=_("Distance, in kilometers, to consider as "
                                              "\"short\"; below this value, the \"short distance "
                                              "label\" will be displayed instead of the default "
                                              "one"),
                                required=True,
                                default=1)

    short_distance_message = I18nTextLineField(title=_("Short distance label format"),
                                               description=_("String used to display search "
                                                             "results distance from reference "
                                                             "point located within the short "
                                                             "distance length; the value of the "
                                                             "short distance can be replaced "
                                                             "using {} characters"),
                                               required=False)

    no_result_message = I18nTextField(title=_("No result message"),
                                      description=_("This message will be displayed in the "
                                                    "results list if no result can be found; you "
                                                    "can use reStructuredText format to handle "
                                                    "**bold** or *italic* text; must must enter "
                                                    "newlines using empty lines"),
                                      required=False)

    display_activity_switch = Bool(title=_("Display activity switch?"),
                                   description=_("If 'no', the button used to switch between "
                                                 "forests and activities will not be displayed"),
                                   required=True,
                                   default=True)

    display_list_switch = Bool(title=_("Display list switch?"),
                               description=_("If 'no', the button used to switch between map "
                                             "and list modes will not be displayed"),
                               required=True,
                               default=True)


class IForestsAndActivitiesListSearchResultsPortletRendererSettings(
        IHeadFiltersSearchResultsPortletRendererSettings):
    """Forests and activities search results portlet renderer settings"""
