#
# Copyright (c) 2015-2020 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""ONF_website.shared.hub.skin module

"""

from pyramid.events import subscriber
from zope.traversing.interfaces import IBeforeTraverseEvent

from onf_website.features.header.skin import ONFDefaultHeaderRenderer
from onf_website.skin.public.interfaces import IBodyClass, PYAMS_MAIN_CLASS_KEY
from onf_website.skin.public.internal import IONFInternalLayer
from onf_website.skin.public.layer import IONFBaseLayer
from onf_website.skin.public.satellite.live import IONFLiveLayer
from pyams_content.shared.hub.interfaces import IHubManager
from pyams_default_theme.features.header.interfaces import PYAMS_HEADER_MAIN_CLASS_KEY, \
    PYAMS_HEADER_NAVIGATION_INNER_CLASS_KEY, PYAMS_HEADER_TEMPLATE_NAME_KEY, \
    PYAMS_HEADER_TITLE_INNER_CLASS_KEY
from pyams_default_theme.features.header.skin import IInnerNavigationClass
from pyams_template.template import override_template
from pyams_utils.adapter import adapter_config


__docformat__ = 'restructuredtext'


@adapter_config(context=(IHubManager, IONFBaseLayer),
                provides=IBodyClass)
def hub_manager_body_class_adapter(context, request):
    return 'front'


@adapter_config(context=(IHubManager, IONFBaseLayer),
                provides=IInnerNavigationClass)
def hub_manager_inner_nav_class_adapter(context, request):
    return 'main-nav--hub'


@subscriber(IBeforeTraverseEvent, context_selector=IHubManager)
def handle_hub_manager_traverse(event):
    """Mark request before traversing hub"""
    annotations = event.request.annotations
    annotations[PYAMS_HEADER_TITLE_INNER_CLASS_KEY] = 'satellite-website-title--hub'
    annotations[PYAMS_HEADER_MAIN_CLASS_KEY] = 'wrapper-header--hub'
    annotations[PYAMS_HEADER_NAVIGATION_INNER_CLASS_KEY] = 'main-nav--hub'


@subscriber(IBeforeTraverseEvent, context_selector=IHubManager, request_selector=IONFLiveLayer)
def handle_hub_manager_live_layer_traverser(event):
    """Mark request before traversing hub"""
    annotations = event.request.annotations
    annotations[PYAMS_MAIN_CLASS_KEY] = 'hub-live'


override_template(name='hub-header-internal',
                  context=ONFDefaultHeaderRenderer, layer=IONFInternalLayer,
                  template='templates/hub-header-internal.pt')


@subscriber(IBeforeTraverseEvent, context_selector=IHubManager,
            request_selector=IONFInternalLayer)
def handle_internal_hub_manager_traverse(event):
    """Handle hub traversing from internal layer"""
    annotations = event.request.annotations
    annotations[PYAMS_HEADER_TEMPLATE_NAME_KEY] = 'hub-header-internal'
