#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from onf_website import _
from onf_website.shared.expengine import IExpEngineMenusContainer, IWfExpEngine
from pyams_content.features.menu.zmi import IMenusView, MenusTable, MenusView
from pyams_form.interfaces.form import IInnerSubForm
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.adapter import NullAdapter, adapter_config
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION
from pyams_viewlet.viewlet import viewlet_config
from pyams_zmi.interfaces import IPropertiesEditForm
from pyams_zmi.interfaces.menu import IPropertiesMenu


@adapter_config(name='expengine-menus',
                context=(IWfExpEngine, IPyAMSLayer, IPropertiesEditForm),
                provides=IInnerSubForm)
@adapter_config(name='++ass++menus', context=(IExpEngineMenusContainer, IPyAMSLayer), provides=IMenusView)
class ExpEngineMenusView(MenusView):
    """Experiential engine menus view"""

    title = _("Engine menus")

    table_class = MenusTable
    weight = 11


@viewlet_config(name='associations.menu', context=IWfExpEngine, layer=IPyAMSLayer,
                manager=IPropertiesMenu)
class ExpEngineAssociationsView(NullAdapter):
    """Experiential engine associations view is removed !!"""
