#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from pyramid.view import view_config
from z3c.form import field
from zope.interface import Interface

from onf_website import _
from onf_website.shared.expengine.interfaces import IExpEngineManager, IWfExpEngine, IWfExpEngineInfo
from pyams_content.interfaces import CREATE_CONTENT_PERMISSION
from pyams_content.shared.common.zmi import SharedContentAJAXAddForm, SharedContentAddForm
from pyams_content.shared.common.zmi.properties import SharedContentPropertiesEditForm
from pyams_form.interfaces.form import IInnerSubForm
from pyams_i18n.interfaces import II18n
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.interfaces import IContentTitle
from pyams_skin.interfaces.viewlet import IMenuHeader, IWidgetTitleViewletManager
from pyams_skin.layer import IPyAMSLayer
from pyams_skin.viewlet.toolbar import ToolbarAction
from pyams_utils.adapter import ContextRequestAdapter, ContextRequestViewAdapter, adapter_config
from pyams_viewlet.viewlet import viewlet_config
from pyams_zmi.form import InnerAdminEditForm
from pyams_zmi.interfaces.menu import IContentManagementMenu
from pyams_zmi.layer import IAdminLayer


@adapter_config(context=(IWfExpEngine, IContentManagementMenu), provides=IMenuHeader)
class ExpEngineContentMenuHeader(ContextRequestAdapter):
    """Experiential engine menu header adapter"""

    header = _("This engine")


@adapter_config(context=(IWfExpEngine, IPyAMSLayer, Interface), provides=IContentTitle)
class ExpEngineTitleAdapter(ContextRequestViewAdapter):
    """Experiential engine title adapter"""

    @property
    def title(self):
        translate = self.request.localizer.translate
        return translate(_("Engine « {title} »")).format(
            title=II18n(self.context).query_attribute('title', request=self.request))


@viewlet_config(name='add-shared-content.action', context=IExpEngineManager, layer=IAdminLayer, view=Interface,
                manager=IWidgetTitleViewletManager, permission=CREATE_CONTENT_PERMISSION, weight=1)
class ExpEngineAddAction(ToolbarAction):
    """Experiential engine adding action"""

    label = _("Add engine")
    label_css_class = 'fa fa-fw fa-plus'
    url = 'add-shared-content.html'
    modal_target = True


@pagelet_config(name='add-shared-content.html', context=IExpEngineManager, layer=IPyAMSLayer,
                permission=CREATE_CONTENT_PERMISSION)
class ExpEngineAddForm(SharedContentAddForm):
    """Experiential engine add form"""

    legend = _("Add experiential engine")


@view_config(name='add-shared-content.json', context=IExpEngineManager, request_type=IPyAMSLayer,
             permission=CREATE_CONTENT_PERMISSION, renderer='json', xhr=True)
class ExpEngineAJAXAddForm(SharedContentAJAXAddForm, ExpEngineAddForm):
    """Experiential engine add form, JSON renderer"""


#
# Custom properties edit form
#

@adapter_config(name='properties',
                context=(IWfExpEngine, IPyAMSLayer, SharedContentPropertiesEditForm),
                provides=IInnerSubForm)
class ExpEnginePropertiesEditForm(InnerAdminEditForm):
    """Experiential engine properties edit form"""

    prefix = 'expengine_properties.'

    legend = _("Custom properties")
    fieldset_class = 'bordered no-x-margin margin-y-10'

    fields = field.Fields(IWfExpEngineInfo)
    weight = 1
