#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from pyramid.exceptions import NotFound
from pyramid.view import view_config

from onf_website.shared.expengine import IWfExpEngine
from pyams_content.workflow import check_publication
from pyams_i18n.interfaces import II18n
from pyams_skin.layer import IPyAMSLayer


@view_config(name='get-options.json',
             context=IWfExpEngine, request_type=IPyAMSLayer,
             renderer='json')
@check_publication
def get_options(request):
    """Get all options"""
    result = []
    for menu in request.context.menus.get_visible_items(request):
        subs = [
            {
                'name': II18n(sub).query_attribute('title', request=request),
                'value': sub.__name__,
                'target': sub.get_url(request)
            }
            for sub in menu.get_visible_items(request)
        ]
        result.append({
            'name': II18n(menu).query_attribute('title', request=request),
            'value': menu.__name__,
            'subs': subs
        })
    return result


@view_config(name='get-menu-options.json',
             context=IWfExpEngine, request_type=IPyAMSLayer,
             renderer='json', xhr=True)
@check_publication
def get_menu_options(request):
    """Get menu options"""
    menu_id = request.params.get('menu')
    if not menu_id:
        raise NotFound("Undefined menu object")
    menu = request.context.menus.get(menu_id)
    if menu is None:
        raise NotFound("Can't find given menu ID")
    result = []
    for item in menu.get_visible_items(request):
        title = II18n(item).query_attribute('title', request=request)
        result.append({
            'title': title,
            'choice': title[0].lower() + title[1:] if title else '',
            'item_id': item.__name__,
            'target': item.get_url(request)
        })
    return result
