#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_portal.interfaces import IPortletSettings
from pyams_sequence.interfaces import IInternalReference

# import packages
from onf_website.shared.expengine import EXPENGINE_CONTENT_TYPE
from pyams_i18n.schema import I18nTextLineField
from pyams_sequence.schema import InternalReferenceField

from onf_website import _


#
# Experiential engine portlet settings
#

class IExpEnginePortletSettings(IPortletSettings, IInternalReference):
    """Experiential engine portlet settings interface"""

    title = I18nTextLineField(title=_("Title"),
                              required=False)

    reference = InternalReferenceField(title=_("Selected engine"),
                                       description=_("Reference to selected experiential engine"),
                                       content_type=EXPENGINE_CONTENT_TYPE,
                                       required=True)
