#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import implementer, provider
from zope.schema.fieldproperty import FieldProperty

from onf_website.shared.expengine.interfaces import EXPENGINE_CONTENT_NAME, EXPENGINE_CONTENT_TYPE, IExpEngine, \
    IExpEngineMenusContainer, IWfExpEngine, IWfExpEngineFactory
from pyams_content.component.association.interfaces import ASSOCIATION_CONTAINER_KEY
from pyams_content.features.menu.interfaces import IMenusContainer, IMenusContainerTarget
from pyams_content.shared.common import SharedContent, WfSharedContent, register_content_type
from pyams_content.shared.common.interfaces import IWfSharedContentFactory
from pyams_utils.adapter import adapter_config, get_annotation_adapter


EXPENGINE_MENUS_KEYS = '{0}::menus'.format(ASSOCIATION_CONTAINER_KEY)


@implementer(IWfExpEngine, IMenusContainerTarget)
class WfExpEngine(WfSharedContent):
    """Experiential engine persistent class"""

    content_type = EXPENGINE_CONTENT_TYPE
    content_name = EXPENGINE_CONTENT_NAME

    handle_content_url = False
    handle_header = False
    handle_description = False

    first_menu_leading = FieldProperty(IWfExpEngine['first_menu_leading'])
    second_menu_leading = FieldProperty(IWfExpEngine['second_menu_leading'])

    @property
    def menus(self):
        return get_annotation_adapter(self, EXPENGINE_MENUS_KEYS, IMenusContainer,
                                      markers=IExpEngineMenusContainer, name='++ass++menus')


register_content_type(WfExpEngine, shared_content=False)


@adapter_config(name='menus', context=IWfExpEngine, provides=IMenusContainer)
def expengine_menus_adapter(context):
    """Experiential engine menus adapter"""
    return context.menus


@provider(IWfExpEngineFactory)
@implementer(IExpEngine)
class ExpEngine(SharedContent):
    """Workflow managed experiential engine persistent class"""


@adapter_config(context=IWfExpEngineFactory, provides=IWfSharedContentFactory)
def expengine_content_factory(context):
    return WfExpEngine
