#
# Copyright (c) 2008-2019 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from z3c.form import field

from onf_website.shared.contact.interfaces.field import IContactThemeFieldInfo
from pyams_content.interfaces import MANAGE_CONTENT_PERMISSION
from pyams_content.shared.form.interfaces import IFormField
from pyams_content.shared.form.zmi.field import FormFieldsContainerTable
from pyams_form.form import ajax_config
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.interfaces.viewlet import ITableItemColumnActionsMenu
from pyams_skin.layer import IPyAMSLayer
from pyams_skin.viewlet.toolbar import ToolbarMenuItem
from pyams_viewlet.viewlet import viewlet_config
from pyams_zmi.form import AdminDialogEditForm
from pyams_zmi.layer import IAdminLayer


__docformat__ = 'restructuredtext'

from onf_website import _


@viewlet_config(name='contact-theme-field-info.menu', context=IFormField, layer=IAdminLayer,
                view=FormFieldsContainerTable, manager=ITableItemColumnActionsMenu,
                permission=MANAGE_CONTENT_PERMISSION)
class ContactThemeFieldInfoMenu(ToolbarMenuItem):
    """Contact theme field information menu"""

    label = _("Selected themes...")
    label_css_class = 'fa fa -fw fa-tags'
    url = 'contact-theme-field-info.html'
    modal_target = True
    stop_propagation = True

    def __new__(cls, context, request, view, manager):
        if IContactThemeFieldInfo(context, None) is None:
            return None
        return ToolbarMenuItem.__new__(cls)


@pagelet_config(name='contact-theme-field-info.html', context=IFormField, layer=IPyAMSLayer,
                permission=MANAGE_CONTENT_PERMISSION)
@ajax_config(name='contact-theme-field-info.json', context=IFormField, layer=IPyAMSLayer)
class ContactThemeFieldInfoEditForm(AdminDialogEditForm):
    """Contact theme field information edit form"""

    legend = _("Edit contact theme field properties")

    dialog_class = 'modal-large'
    icon_css_class = 'fa fa-fw fa-tags'

    fields = field.Fields(IContactThemeFieldInfo)

    def getContent(self):
        return IContactThemeFieldInfo(self.context)
