#
# Copyright (c) 2008-2019 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.annotation import IAttributeAnnotatable
from zope.container.constraints import contains
from zope.container.interfaces import IContainer
from zope.interface import Interface
from zope.schema import Text, TextLine

from onf_website.shared.contact.interfaces import CONTACT_CONTENT_TYPE
from pyams_i18n.schema import I18nHTMLField, I18nTextField, I18nTextLineField
from pyams_sequence.schema import InternalReferenceField


__docformat__ = 'restructuredtext'

from onf_website import _


CONTACT_THEMES_VOCABULARY = 'ONF contact themes'


class IContactTheme(Interface):
    """Contact theme"""

    name = TextLine(title=_("Name"),
                    description=_("Name of this contact theme must be unique between all themes"),
                    required=True)

    internal_label = TextLine(title=_("Internal label"),
                              description=_("This label will be used in back-office only..."),
                              required=False)

    label = I18nTextLineField(title=_("Selection label"),
                              description=_("Alternate selection label used into contact forms"),
                              required=False)

    def get_label(self, request):
        """Get label or title"""

    crm_category = TextLine(title=_("CRM category"),
                            description=_("If this theme is matching a CRM category,"
                                          "please define it here"),
                            required=False)

    header = I18nHTMLField(title=_("Header"),
                           description=_("This text will be displayed automatically in front-office "
                                         "when this theme will be selected"),
                           required=False)

    teaser = I18nTextField(title=_("Teaser"),
                           description=_("This short text will be displayed as introduction before links associated "
                                         "with this theme, if any"),
                           required=False)

    reference = InternalReferenceField(title=_("Default contact"),
                                       description=_("Contact to use when no specific contact can be found for this "
                                                     "theme"),
                                       required=False,
                                       content_type=CONTACT_CONTENT_TYPE)

    notepad = Text(title=_("Notepad"),
                   description=_("Internal information to be known about this theme"),
                   required=False)


CONTACT_THEME_MANAGER_ANNOTATION_KEY = 'onf_website.contact.theme.manager'


class IContactThemeManager(IContainer):
    """Contact themes container"""

    contains(IContactTheme)


class IContactThemeManagerTarget(IAttributeAnnotatable):
    """Contact theme manager target interface"""
