#
# Copyright (c) 2008-2019 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from collections import OrderedDict

from zope.interface import Interface
from zope.schema import List, Choice, Bool
from zope.schema.vocabulary import SimpleVocabulary, SimpleTerm

from onf_website.shared.contact.interfaces.theme import CONTACT_THEMES_VOCABULARY

from onf_website import _


#
# Contact themes field interfaces
#

CONTACT_THEME_FIELD_INFO_ANNOTATION_KEY = 'onf_website.contact.theme.field'

ALWAYS_DISPLAY_MODE = 'always'
MULTIPLE_DISPLAY_MODE = 'multiple'
HIDE_PRESELECTED_DISPLAY_MODE = 'unselected'
HIDDEN_DISPLAY_MODE = 'hidden'

CONTACT_THEMES_WIDGET_DISPLAY_MODES = OrderedDict((
    (ALWAYS_DISPLAY_MODE, _("Always display selection list")),
    (MULTIPLE_DISPLAY_MODE, _("Display selection list only when multiple options")),
    (HIDE_PRESELECTED_DISPLAY_MODE, _("Hide selection list if pre-selected value")),
    (HIDDEN_DISPLAY_MODE, _("Always hide selection list"))
), )

CONTACT_THEMES_WIDGET_DISPLAY_MODES_VOCABULARY = SimpleVocabulary(
    [SimpleTerm(k, title=v) for k, v in CONTACT_THEMES_WIDGET_DISPLAY_MODES.items()])


class IContactThemeFieldInfo(Interface):
    """Contact theme field information interface"""

    themes = List(title=_("Available themes"),
                  description=_("Select the list of themes which will be available in contact "
                                "form"),
                  required=False,
                  value_type=Choice(vocabulary=CONTACT_THEMES_VOCABULARY))

    display_mode = Choice(title=_("Display mode"),
                          description=_("Define how themes selection widget will not be "
                                        "displayed..."),
                          vocabulary=CONTACT_THEMES_WIDGET_DISPLAY_MODES_VOCABULARY,
                          default=MULTIPLE_DISPLAY_MODE,
                          required=True)


CONTACT_THEME_FIELD_VALUES_VOCABULARY = 'onf_website.contact.theme.vocabulary'
CONTACT_THEMES_LIST_FIELD_VALUES_VOCABULARY = 'onf_website.contact.themes_list.vocabulary'
CONTACT_FORM_THEMES_FIELD_VALUES_VOCABULARY = 'onf_website.contact.form_themes.vocabulary'
