#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.schema import Set, Choice

from onf_website.reference.forest.schema import ForestsListField
from onf_website.reference.orga.schema import StructuresListField
from pyams_content.shared.common.interfaces import IManagerRestrictionInfo as IManagerRestrictionInfoBase

from onf_website import _


REST_CONTENT_PUBLIC_SEARCH_ROUTE = 'onf_website.rest.search'
REST_CONTENT_PUBLIC_SEARCH_ROUTE_SETTING = 'onf_website.api.rest.shared_content_search_route'
REST_CONTENT_PUBLIC_SEARCH_ROUTE_DEFAULT = '/api/onf/rest/{content_type}'

REST_CONTENT_PUBLIC_GETTER_ROUTE = 'onf_website.rest.getter'
REST_CONTENT_PUBLIC_GETTER_ROUTE_SETTING = 'onf_website.api.rest.shared_content_getter_route'
REST_CONTENT_PUBLIC_GETTER_ROUTE_DEFAULT = '/api/onf/rest/{content_type}/{oid}'


class IManagerRestrictionInfo(IManagerRestrictionInfoBase):
    """Manager restrictions interface"""

    countries = Set(title=_("Countries"),
                    description=_("List of location countries which manager can manage"),
                    value_type=Choice(vocabulary='ONF countries'),
                    required=False)

    departments = Set(title=_("Departments"),
                      description=_("List of location departments which manager can manage"),
                      value_type=Choice(vocabulary='ONF departments'),
                      required=False)

    structures = StructuresListField(title=_("Structures"),
                                     description=_("List of location structures which manager can manage"),
                                     required=False)

    forests = ForestsListField(title=_("Forests"),
                               description=_("List of location forests which manager can manager"),
                               required=False)
