#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from onf_website.component.hearing.interfaces import IHearingTarget, IHearingManagerTarget
from pyams_content.shared.blog.interfaces import IBlogManager
from pyams_content.shared.common.interfaces import IManagerRestrictionsFactory

# import packages
from onf_website.shared.common.security import SharedToolManagerRestrictionInfo
from pyams_content.shared.blog import WfBlogPost
from pyams_content.shared.blog.manager import BlogManager
from pyams_utils.adapter import adapter_config
from zope.interface import classImplements


#
# Blog post interfaces
#

classImplements(WfBlogPost, IHearingTarget)


#
# Blog manager interfaces
#

classImplements(BlogManager, IHearingManagerTarget)
classImplements(BlogManager, IHearingTarget)


@adapter_config(context=IBlogManager, provides=IManagerRestrictionsFactory)
def blog_manager_restrictions_factory(context):
    """Blog manager restrictions factory"""
    return SharedToolManagerRestrictionInfo
