#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'

from z3c.form import field

from onf_website.shared.activity.interfaces import IActivityManager
from pyams_content.component.theme.interfaces import IThemesManager
from pyams_content.shared.common.zmi.manager import SharedToolPropertiesEditForm
from pyams_form.group import NamedWidgetsGroup
from pyams_form.interfaces.form import IInnerSubForm
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.adapter import adapter_config
from pyams_zmi.form import InnerAdminEditForm

from onf_website import _


@adapter_config(name='adaptations-themes',
                context=(IActivityManager, IPyAMSLayer, SharedToolPropertiesEditForm),
                provides=IInnerSubForm)
class ActivityManagerDisabilityThemesEditForm(InnerAdminEditForm):
    """Activity manager disability themes edit form"""

    prefix = 'adaptations_themes.'

    legend = _("Adapted accesses themes settings")
    fieldset_class = 'bordered no-x-margin margin-y-10'

    fields = field.Fields(IActivityManager).select('adaptations_themes',
                                                   'foretmapper_adaptations_themes')

    weight = 1

    def updateWidgets(self, prefix=None):
        super().updateWidgets(prefix)
        for name in ('adaptations_themes', 'foretmapper_adaptations_themes'):
            themes = self.widgets.get(name)
            if themes is not None:
                themes_manager = IThemesManager(self.context, None)
                if themes_manager is not None:
                    themes.thesaurus_name = themes_manager.thesaurus_name
                    themes.extract_name = themes_manager.extract_name


@adapter_config(name='hearing-settings',
                context=(IActivityManager, IPyAMSLayer, SharedToolPropertiesEditForm),
                provides=IInnerSubForm)
class ActivityManagerHearingSettingsEditForm(InnerAdminEditForm):
    """Activity manager hearing settings edit form"""

    prefix = 'hearing_properties.'

    legend = _("Hearing settings")
    fieldset_class = 'bordered no-x-margin margin-y-10'

    fields = field.Fields(IActivityManager).select('default_hearing_source',
                                                   'default_source_folder')

    weight = 10


@adapter_config(name='infos-renderers',
                context=(IActivityManager, IPyAMSLayer, SharedToolPropertiesEditForm),
                provides=IInnerSubForm)
class ActivityManagerInfosRenderersEditForm(InnerAdminEditForm):
    """Activity manager infos renderers edit form"""

    prefix = 'infos_renderers.'

    legend = _("Displayed informations")
    fieldset_class = 'bordered no-x-margin margin-y-10'

    fields = field.Fields(IActivityManager).select('infos_renderers', 'fixed_renderers_count')

    weight = 20
