#
# Copyright (c) 2015-2022 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'

from pyramid.view import view_config

from onf_website.reference.planning import IPlanningTable
from pyams_content.root import ISiteRoot
from pyams_default_theme.features.sitemap import ISitemapExtension
from pyams_skin.layer import IPyAMSUserLayer
from pyams_utils.adapter import ContextRequestAdapter, adapter_config
from pyams_utils.registry import query_utility


@adapter_config(name='plannings',
                context=(ISiteRoot, IPyAMSUserLayer),
                provides=ISitemapExtension)
class SiteRootPlanningsSitemap(ContextRequestAdapter):
    """Site root plannings sitemap extension"""

    @property
    def source(self):
        return query_utility(IPlanningTable)


@view_config(name='sitemap.xml',
             context=IPlanningTable, request_type=IPyAMSUserLayer,
             renderer='templates/plannings-sitemap.pt')
class PlanningTableSitemapView:
    """Planning table sitemap view"""

    def __init__(self, request):
        self.request = request

    def __call__(self):
        self.request.response.content_type = 'text/xml'
        return {}
