
from zope.interface import Interface, Attribute
from zope.schema import Text, TextLine, Bool, Date

from onf_website import _


class IPlanningModel(Interface):
    """Abstract base model interface for planning"""


class IPlanningData(Interface):
    """Abstract base class interface"""

    id_nat_amgt = TextLine(title=_("National ID"))
    statut = TextLine(title=_("Status"))
    annee_debut_amenagement = TextLine(title=_("Start"))
    annee_echeance_amenagement = TextLine(title=_("End"))


class IInformationPlanning(Interface):
    """Custom planning information interface"""

    id_nat_amgt = TextLine(title=_("National ID"))

    libelle = TextLine(title=_("Custom label"),
                       required=False)

    header = Text(title=_("Custom header"),
                  required=False)


class IModificationPlanning(Interface):
    """Custom planning modification interface"""
