#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from zope.schema.interfaces import ITextLine

# import packages
from zope.interface import implementer
from zope.schema import TextLine, List


class IStructureField(ITextLine):
    """Structure field interface"""


@implementer(IStructureField)
class StructureField(TextLine):
    """Structure field"""


class IStructuresListField(ITextLine):
    """Structures list field interface"""


@implementer(IStructuresListField)
class StructuresListField(List):
    """Structures list field"""

    def __init__(self, value_type=None, unique=False, *args, **kwargs):
        super(StructuresListField, self).__init__(value_type=TextLine(),
                                                  unique=True,
                                                  *args, **kwargs)
