#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

from zope.container.constraints import contains, containers
from zope.schema import TextLine, List, Choice

from onf_website import _
from onf_website.reference.location.interfaces import IBaseLocationInfo
# import interfaces
from pyams_content.reference.interfaces import IReferenceTable
# import packages
from pyams_content.shared.logo import WfLogo
from pyams_sequence.schema import InternalReferenceField


class IRegion(IBaseLocationInfo):
    """Region interface"""

    containers('.IRegionTable')

    insee_code = TextLine(title=_("INSEE code"),
                          required=False)

    logo = InternalReferenceField(title=_("Logo"),
                                  description=_("Logo associated with this region"),
                                  content_type=WfLogo.content_type,
                                  required=False)

    def get_logo(self):
        """Get reference to selected logo"""

    territory = Choice(title=_("Territory"),
                       vocabulary='ONF territories',
                       required=False)

    departments = List(title=_("Departments"),
                       value_type=Choice(vocabulary='ONF departments'),
                       required=False)

    neighbors = List(title=_("Neighbors regions"),
                     value_type=Choice(vocabulary='ONF regions'),
                     required=False)


class IRegionTable(IReferenceTable):
    """Region table"""

    contains(IRegion)
