#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_content.reference.interfaces import IReferenceInfo

# import packages
from pyams_i18n.schema import I18nTextLineField

from onf_website import _


class IBaseLocationInfo(IReferenceInfo):
    """Base location info"""

    localization_title = I18nTextLineField(title=_("Localization title"),
                                           description=_("Title used for localization, with prefix"),
                                           required=False)

    appropriation_title = I18nTextLineField(title=_("Appropriation title"),
                                            description=_("Title used for appropriation, with prefix"),
                                            required=False)
